﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Core" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="System.Linq" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>DokEwidencji</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
    <script runat="server">
        Soneta.Kasa.StanRozliczeniaRozrachunkuWorker stanRozliczeniaWorker;
        void OnContextLoad(Object sender, EventArgs args)
        {
            stanRozliczeniaWorker =
                new Soneta.Kasa.StanRozliczeniaRozrachunkuWorker { StanRozliczenia = Soneta.Kasa.StanRozliczeniaRozrachunku.Nierozliczone };
        }

        void Grid1_OnBeforeRow(object sender, Soneta.Web.RowEventArgs args)
        {
            var elem = args.Row as Soneta.Ksiega.ElemOpisuAnalitycznego;
            if (elem == null) return;
            
            var platnosc = elem.PlatnoscPowiazana;
            if (platnosc == null) return;

            var data = platnosc.Dokument.Ewidencja.DataOperacji;

            stanRozliczeniaWorker.RozrachunekIdx = platnosc.Rozrachunki.GetNext() as RozrachunekIdx;

            KwotaNierozliczonaPLN.EditValue = stanRozliczeniaWorker.ZobowiazaniePLNHist(data);
            KwotaNierozliczona.EditValue = stanRozliczeniaWorker.Zobowiazanie(data);

            SumaPlatnosciPLN.EditValue = platnosc.Dokument.Ewidencja.Platnosci.Cast<Platnosc>().
                Where(p => p.Typ == TypRozrachunku.Zobowiązanie).
                Aggregate(Currency.Zero, (suma, p) => suma + p.KwotaKsiegi);

            try
            {
                SumaPlatnosci.EditValue = platnosc.Dokument.Ewidencja.Platnosci.Cast<Platnosc>().
                    Where(p => p.Typ == TypRozrachunku.Zobowiązanie).
                    Aggregate(Currency.Zero, (suma, p) => suma + p.Kwota);
            }
            catch
            {
                SumaPlatnosci.EditValue = "różne waluty";
            }
        }
    </script>
</head>
<body>
    <form method="post" runat="server" id="form">
        <ea:DataContext id="dc" runat="server" OnContextLoad="OnContextLoad"
            TypeName="Soneta.Ksiega.PKEwidencja,Soneta.Ksiega" BottomMargin="10"
            LeftMargin="10" RightMargin="10" TopMargin="10">
        </ea:DataContext>
        <eb:ReportHeader id="ReportHeader" runat="server"
            title="Korekty kosztów podatkowych| Numer dokumentu: {0}|Data: {1}|Opis: {2}" DataMember0="Numer.NumerPelny"
            DataMember1="DataDokumentu" DataMember2="Opis">
        </eb:ReportHeader>


        <ea:Grid runat="server" ID="Grid1" DataMember="OpisAnalityczny" OnBeforeRow="Grid1_OnBeforeRow"
            RowTypeName="Soneta.Ksiega.ElemOpisuAnalitycznego,Soneta.Ksiega" 
            RowsInRow="3">
            <columns>
			<ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="LP." RowSpan="3"></ea:GridColumn>
			<ea:GridColumn Align="Left" DataMember="Wymiar" Caption="Numer dokumentu"></ea:GridColumn>
			<ea:GridColumn Align="Right" DataMember="PlatnoscPowiazana.Termin" 
                    Caption="Termin płatności"></ea:GridColumn>
			<ea:GridColumn Align="Left" DataMember="Opis" Caption="Opis" ColSpan="5"></ea:GridColumn>
            <ea:GridColumn Width="20" Align="Right" ID="KwotaNierozliczona" 
                    Caption="Kwota nierozliczona"></ea:GridColumn>
			<ea:GridColumn Width="20" Align="Right" Caption="Suma zobowiązań" 
                    ID="SumaPlatnosci"></ea:GridColumn>
            <ea:GridColumn Width="20" Align="Right" ID="KwotaNierozliczonaPLN" 
                    Caption="Kwota nierozliczona PLN"></ea:GridColumn>
            <ea:GridColumn Width="20" Align="Right" ID="SumaPlatnosciPLN" 
                    Caption="Suma zobowiązań PLN"></ea:GridColumn>
			<ea:GridColumn Align="Left" DataMember="Symbol" Caption="Konto/Nr dok. rozch." Total="Info"></ea:GridColumn>
			<ea:GridColumn Align="Right" 
                DataMember="ZapisPowiazany.KwotaZapisu" Caption="Kwota zapisu"></ea:GridColumn>
			<ea:GridColumn Width="16" Align="Right" DataMember="KwotaDodatkowa" 
                    Caption="Propozycja korekty" Total="Sum"></ea:GridColumn>
			<ea:GridColumn Width="16" Align="Right" DataMember="Kwota" Caption="Korekta" 
                    Total="Sum"></ea:GridColumn>
			<ea:GridColumn Caption="Uwagi" RowSpan="3"></ea:GridColumn>
		</columns>
        </ea:Grid>
        <eb:ReportFooter id="ReportFooter" runat="server">
            <subtitles>
                    <eb:FooterSubtitle runat="server" SubtitleType="Operator" Width="50">
                    </eb:FooterSubtitle>
                    <eb:FooterSubtitle runat="server" SubtitleType="Podpis" Width="50">
                    </eb:FooterSubtitle>
                </subtitles>
        </eb:ReportFooter>
    </form>
</body>
</html>
